<!doctype html>
<html class="no-js" lang="zxx">

<?php include('header.php');?>

<body>
    <header>
        <?php include('menu.php');?>
    </header>
    <div class="featured_candidates_area candidate_page_padding">
        <div class="container">
            <div class="row">
				<div class="col-lg-2"></div>
				<div class="col-lg-8">
					<div class="header">
						<h1 class="header__title"><i class="fas fa-user-cog"></i>Settings</h1>
					</div>
					<!--PEN CONTENT-->
					<div class="content">
					  <!--content inner-->
					  <div class="content__inner">
						<!--tabs-->
						<div class="tabs">
						  <!--tabs navigation-->
						  <div class="tabs__nav">
							<ul class="tabs__nav-list">
							  <li class="noselect tabs__nav-item js-active" data-panel="security"><i class="fas fa-unlock-alt"></i> Security</li>
							  <li class="noselect tabs__nav-item" data-panel="twofactor"><i class="fas fa-qrcode"></i> Two factor</li>
							  <li class="noselect tabs__nav-item" data-panel="privacy"><i class="fas fa-user-cog"></i> Privacy</li>
							  <li class="noselect tabs__nav-item" data-panel="delete"><i class="fas fa-user-times"></i> Delete Account</li>
							</ul>
							
						  </div>
						  <!--tabs panels-->
						  <div class="tabs__panels">
							<!--single panel-->
							<div class="tabs__panel" id="security">
								<div class="tabs__panel-content">
									<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 600px;"> 
										<span class="input-group-addon" style="border-radius: 0px; padding: 14px 16.5px"><i class="fa fa-lock"></i></span> 
										<input id="old_password" type="password" class="form-control" name="old_password" placeholder="Old password" style="height: 45px;">
									</div>
									<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 600px;">
										<span class="input-group-addon" style="border-radius: 0px; padding: 14px 16.5px"><i class="fa fa-lock"></i></span> 
										<input id="new_password" type="password" class="form-control" name="new_password" placeholder="New password" style="height: 45px;">
									</div>
									<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 600px;"> 
										<span class="input-group-addon" style="border-radius: 0px; padding: 14px 16.5px"><i class="fa fa-lock"></i></span> 
										<input id="confirm_password" type="password" class="form-control" name="confirm_password" placeholder="Confirm new password" style="height: 45px;"> 
										</div>
									<div class="input-group" style="margin: 20px auto 50px; height: 45px; width: 100%; max-width: 600px;"> 
										<input type="submit" id="process_change_password" onclick="process_change_password()" class="btn btn-success" value="Set password" style="height: 45px; width: 100%; font-size: 14px;"> 
									</div>
									
									<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 600px;"> 
										<span class="input-group-addon" style="border-radius: 0px; padding: 14px 16.5px"><i class="fas fa-envelope-open-text"></i></span> 
										<input id="your_email" type="text" class="form-control" name="your_email" value="<?=$this->user_info->user_email?>" placeholder="Your email" style="height: 45px; font-size: 14px; background: #FFF" readonly="readonly"> 
									</div>
									<div class="input-group" style="margin: 20px auto 50px; height: 45px; width: 100%; max-width: 600px;"> 
										<input type="submit" id="process_verify_email" onclick="process_verify_email()" class="btn btn-success" value="Verify email" style="height: 45px; width: 100%; font-size: 14px;">
									</div>
								</div>
							</div>
							<!--single panel-->
							<div class="tabs__panel" id="twofactor">
								<div class="tabs__panel-content">
									<?php if($user_info->enable_2fa == 0):?>
									<div id="enable_2fa"> 
										<div style="text-align: center; margin: 20px auto; 0px; font-size: 15px; line-height: 20px; max-width: 600px;"> 
											Please scan the QR code below into your 2 factor authentication app (Google Authenticator, Authy etc.) and enter the code generated by the app below to activate 2 factor authentication. Please also write down the secret key shown below as you will need it to restore 2 factor authentication in case your phone is lost or stolen<br> 
										</div> 
										<div id="qrcode" style="width:200px; height:200px; border: 5px solid #FFF; margin: 30px auto 0px;" title="otpauth://totp/23989@bitpick.io?secret=ODRVTHBDSS2JWQOP">
										</div>
										<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 600px;"> 
											<span class="input-group-addon" style="border-radius: 0px; padding: 14px 13.5px"><i class="fas fa-user-secret"></i></span> 
											<input id="secret_code" type="text" class="form-control" readonly="readonly" name="secret_code" style="height: 45px; background: #FFF; font-weight: bold; font-size: 14px" placeholder="Secret code" value="<?=$this->user_info->secret_2fa_code?>"> <input id="user_id" type="hidden" class="form-control" readonly="readonly" name="user_id" style="height: 45px; background: #FFF; font-weight: bold" value="23989">
											<span class="input-group-addon" style="color: #2196f3; border-radius: 0px; padding: 12px 12.5px; border-left: none; border-right: 1px solid #DDD; cursor: pointer; font-size: 16px"><i class="fas fa-copy"></i></span>
										</div> 
										<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 600px;"> 
											<span class="input-group-addon" style="border-radius: 0px; padding: 14px 13.5px"><i class="fas fa-keyboard"></i></span> 
											<input id="enable_2fa_code" type="number"  maxlength="6" class="form-control" name="enable_2fa_code" style="height: 45px; background: #FFF;" placeholder="Enter 2FA code"> 
										</div> 
										<div class="input-group" style="margin: 20px auto 0px; height: 45px;  max-width: 600px;"> 
											<input type="button" id="process_enable_2fa_code" onclick="process_enable_2fa_code()" class="btn btn-success" value="Enable 2FA" style="height: 45px; width: 100%; font-size: 14px;"> 
										</div> 
									</div>
									<?php else:?>
									<div id="disable_2fa">
										<div style="text-align: center; margin: 20px auto; 0px; font-size: 15px; line-height: 20px; max-width: 600px;"> 
											Two-factor authentication is currently <span style="color: green">enable</span>. To disable, enter your password and two-factor code below.
										</div> 
										<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 600px;"> 
											<span class="input-group-addon" style="border-radius: 0px; padding: 14px 13.5px"><i class="fa fa-lock"></i></span> 
											<input id="disable_password" type="password" class="form-control" name="disable_password" style="height: 45px; background: #FFF;" placeholder="Password"> 
										</div>
										<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 600px;"> 
											<span class="input-group-addon" style="border-radius: 0px; padding: 14px 13.5px"><i class="fas fa-keyboard"></i></span> 
											<input id="disable_2fa_code" type="number" maxlength="6" class="form-control" name="disable_2fa_code" style="height: 45px; background: #FFF;" placeholder="Enter 2FA code"> 
										</div> 
										<div class="input-group" style="margin: 20px auto 0px; height: 45px;  max-width: 600px;"> 
											<input type="button" id="process_disable_2fa_code" onclick="process_disable_2fa_code()" class="btn btn-danger" value="Disable 2FA" style="height: 45px; width: 100%; font-size: 14px;"> 
										</div> 
									</div>
									<?php endif?>
								</div>
							</div>
							<!--single panel-->
							<div class="tabs__panel" id="privacy">
								<div class="tabs__panel-content">
									<div class="input-group" style="margin: 0px auto 0px; height: 45px; max-width: 600px; font-size: 14px"> 
										<div class="checkbox icheck-primary">
										  <input type="checkbox" checked id="primary" />
										  <label for="primary">Payment Notifications</label>
										</div>
									</div>
									<div class="input-group" style="margin: 0px auto 0px; height: 45px; max-width: 600px; font-size: 14px"> 
										<div class="checkbox icheck-primary">
										  <input type="checkbox" checked id="primary1" />
										  <label for="primary1">Deposit Notifications</label>
										</div>
									</div>
									<div class="input-group" style="margin: 0px auto 0px; height: 45px; max-width: 600px; font-size: 14px"> 
										<div class="checkbox icheck-primary">
										  <input type="checkbox" checked id="primary2" />
										  <label for="primary2">Password Update Notifications</label>
										</div>
									</div>
									<div class="input-group" style="margin: 0px auto 0px; height: 45px; max-width: 600px; font-size: 14px"> 
										<div class="checkbox icheck-primary">
										  <input type="checkbox" checked id="primary3" />
										  <label for="primary3">Promotions</label>
										</div>
									</div>
									<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 600px;"> 
										<input type="button" id="enable_2fa_button" class="btn btn-success" value="Update" style="height: 45px; width: 100%; font-size: 14px"> 
									</div> 
									<?php if(!$user_info->enable_2fa):?>
									<center style="font-weight: bold; font-size: 14px; margin-top: 50px">You currently do not have Email security</center>
									<div class="input-group" style="margin: 5px auto 0px; height: 45px; width: 100%; max-width: 600px;">
										<input type="submit" class="btn btn-info" value="Enable Email security" style="height: 45px; width: 100%; font-size: 14px;">
									</div>
									<?php endif?>
								</div>
							</div>
							<!--single panel-->
							<div class="tabs__panel" id="delete">
								<div class="tabs__panel-content">
									<div id="enable_2fa"> 
										<div style="text-align: center; margin: 20px auto; 0px; font-size: 15px; line-height: 20px; max-width: 600px;"> 
											All usage history and personal data cannot be recovered after deleting your account from Rocket.
											Please confirm the account you wish to delete and enter your password once more.<br/>
											<span style="color: #f44336; font-weight: bold">*All coins remaining in your wallet will be lost upon deleting your account.</span>
										</div> 
										<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 600px;"> <span class="input-group-addon" style="border-radius: 0px; padding: 14px 16.5px"><i class="fa fa-lock"></i></span> <input id="new_pwd" type="password" class="form-control" name="new_pwd" placeholder="Enter password" style="height: 45px;"> </div>
										<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 600px;"> <span class="input-group-addon" style="border-radius: 0px; padding: 14px 15.5px"><i class="fas fa-keyboard"></i></span> <input id="old_pwd" type="password" class="form-control" name="old_pwd" placeholder="Enter 2FA Code" style="height: 45px;"> </div>
										<div class="input-group" style="margin: 20px auto 0px; height: 45px;  max-width: 600px;"> 
											<input type="button" id="enable_2fa_button" class="btn btn-danger" value="Delete account" style="height: 45px; width: 100%; font-size: 14px;"> 
										</div> 
									</div>
								</div>
							</div>
						  </div>
						</div>
					  </div>
					</div>	
				</div>
				<div class="col-lg-2"></div>
			</div>
		 </div>
	</div>
	
    <?php include('footer.php');?>
	<script>
		function process_change_password() {
			$("#process_change_password").attr("disabled", !0);
			var old_password = $('#old_password').val();
			var new_password = $('#new_password').val();
			var confirm_password = $('#confirm_password').val();
			
			$.ajax({
				url: "<?=base_url()?>process.php",
				type: "POST",
				data: "action=change_password&old_password="+old_password+"&new_password="+new_password+"&confirm_password="+confirm_password,
				error: function(){
					console.log("Request timed out. Please try again!");
				},
				success: function(out){
					obj = JSON.parse(out);
					if(obj.ret == 0) {
						Swal.fire('Error!',obj.mes,'error');
					} else {
						Swal.fire('Success!',obj.mes,'success');
					}
					$("#process_change_password").attr("disabled", false);
				}
			});
		}
		
		function process_enable_2fa_code() {
			$("#process_enable_2fa_code").attr("disabled", !0);
			var enable_2fa_code = $('#enable_2fa_code').val();
			
			$.ajax({
				url: "<?=base_url()?>process.php",
				type: "POST",
				data: "action=enable_2fa_code&enable_2fa_code="+enable_2fa_code,
				error: function(){
					console.log("Request timed out. Please try again!");
				},
				success: function(out){
					obj = JSON.parse(out);
					if(obj.ret == 0) {
						Swal.fire('Error!',obj.mes,'error');
					} else {
						Swal.fire('Success!',obj.mes,'success');
						setTimeout(function() {
							window.location.reload();
						}, 500);
					}
					$("#process_enable_2fa_code").attr("disabled", false);
				}
			});
		}
		
		function process_disable_2fa_code() {
			$("#process_disable_2fa_code").attr("disabled", !0);
			var disable_2fa_code = $('#disable_2fa_code').val();
			var disable_password = $('#disable_password').val();
			
			$.ajax({
				url: "<?=base_url()?>process.php",
				type: "POST",
				data: "action=disable_2fa_code&disable_2fa_code="+disable_2fa_code+"&disable_password="+disable_password,
				error: function(){
					console.log("Request timed out. Please try again!");
				},
				success: function(out){
					obj = JSON.parse(out);
					if(obj.ret == 0) {
						Swal.fire('Error!',obj.mes,'error');
					} else {
						Swal.fire('Success!',obj.mes,'success');
						setTimeout(function() {
							window.location.reload();
						}, 500);
					}
					$("#process_disable_2fa_code").attr("disabled", false);
				}
			});
		}
		<?php if($user_info->enable_2fa == 0):?>
		var qrcode = new QRCode("qrcode", {
			text:"otpauth://totp/<?=$user_info->user_id?>@<?=base_url()?>?secret=<?=$user_info->secret_2fa_code ?>",
			width:200,
			height:200,
			colorDark:"#000000",
			colorLight:"#ffffff",
			correctLevel:QRCode.CorrectLevel.H
		});
		<?php endif?>
	</script>
</body>

</html>